!Object constantsFor: 'Geos Libraries'!

geosLIB11 'SYSTEM\color'! !

!Object constantsFor: 'Geos vardata'!

attrColorSelectorDisableObject 27648!
!

!Object constantsFor: 'Geos messages'!

selectorGetColor 27648!
selectorUpdateColor 27649!
selectorSetColor 27650!
selectorApplyColor 27651!
selectorUpdateFilledStatus 27652!
selectorGetFilledMoniker 27653!
selectorGetUnfilledMoniker 27654!
selectorUpdateDrawMask 27655!
selectorGetDrawMask 27656!
selectorSetDrawMask 27657!
selectorApplyDrawMask 27658!
selectorUpdatePattern 27659!
selectorGetPattern 27660!
selectorSetPattern 27661!
selectorApplyPattern 27662!
setFilledStatus 27663!
setCfIndex 27664!
setCfRgbRed 27665!
setCfRgbGreen 27666!
setCfRgbBlue 27667!
setDrawMask 27668!
setPattern 27669!
!

!Geos class methodsFor: 'library calls'!

!

GenControl subclass: #ColorSelector
	instanceVariableNames: ''
	classVariableNames: ''!

!ColorSelector comment!
Library color, file objects/colorc.goh! !

!ColorSelector class methodsFor: 'library linkage'!

library
	^11!

entry
	^0!
!

!ColorSelector methodsFor: 'Geos instance variables'!

csiColor
	"@instance ColorQuad CSI_color"
	^GCSColorQuad forPointer: (self ptrAt: 25).!

csiColor: aBlock
	"@instance ColorQuad CSI_color"
	aBlock value: (GCSColorQuad forPointer: (self ptrAt: 25)).!

csiColorIndeterminate
	"@instance byte CSI_colorIndeterminate"
	^self byteAt: 29!

csiColorIndeterminate: value
	"@instance byte CSI_colorIndeterminate"
	^self byteAt: 29 put: value!

csiDrawMask
	"@instance SystemDrawMask CSI_drawMask"
	^self byteAt: 30!

csiDrawMask: value
	"@instance SystemDrawMask CSI_drawMask"
	^self byteAt: 30 put: value!

csiDrawMaskIndeterminate
	"@instance byte CSI_drawMaskIndeterminate"
	^self byteAt: 31!

csiDrawMaskIndeterminate: value
	"@instance byte CSI_drawMaskIndeterminate"
	^self byteAt: 31 put: value!

csiPattern
	"@instance GraphicPattern CSI_pattern"
	^GCSGraphicPattern forPointer: (self ptrAt: 32).!

csiPattern: aBlock
	"@instance GraphicPattern CSI_pattern"
	aBlock value: (GCSGraphicPattern forPointer: (self ptrAt: 32)).!

csiPatternIndeterminate
	"@instance byte CSI_patternIndeterminate"
	^self byteAt: 34!

csiPatternIndeterminate: value
	"@instance byte CSI_patternIndeterminate"
	^self byteAt: 34 put: value!

csiStates
	"@instance ColorModifiedStates CSI_states"
	^self byteAt: 35!

csiStates: value
	"@instance ColorModifiedStates CSI_states"
	^self byteAt: 35 put: value!

csiToolboxPrefs
	"@instance ColorToolboxPreferences CSI_toolboxPrefs"
	^self byteAt: 36!

csiToolboxPrefs: value
	"@instance ColorToolboxPreferences CSI_toolboxPrefs"
	^self byteAt: 36 put: value!

!

!ColorSelector methodsFor: 'Geos vardata'!

attrColorSelectorDisableObject: value
	"@vardata optr ATTR_COLOR_SELECTOR_DISABLE_OBJECT"
	^self addVardata: ##attrColorSelectorDisableObject dword: value!

!

!ColorSelector methodsFor: 'Geos messages'!

selectorGetColor: retValue
	"@message Boolean MSG_COLOR_SELECTOR_GET_COLOR( ColorQuad *retValue = dx.cx)= bp"
	^self geosMessage: #[108 0 110 46 3 4] with: retValue!

selectorUpdateColor: colorQuad with: indeterminateFlag
	"@message void MSG_COLOR_SELECTOR_UPDATE_COLOR( ColorQuad colorQuad = dx.cx, Boolean indeterminateFlag = bp)"
	^self geosMessage: #[108 1 3 238 2 4 0] with: colorQuad with: indeterminateFlag!

selectorSetColor: colorQuad with: indeterminateFlag
	"@message void MSG_COLOR_SELECTOR_SET_COLOR( ColorQuad colorQuad = dx.cx, Boolean indeterminateFlag = bp)"
	^self geosMessage: #[108 2 3 238 2 4 0] with: colorQuad with: indeterminateFlag!

selectorApplyColor: colorQuad
	"@message void MSG_COLOR_SELECTOR_APPLY_COLOR(ColorQuad colorQuad = dx.cx)"
	^self geosMessage: #[108 3 2 46 2 0] with: colorQuad!

selectorUpdateFilledStatus: drawMask with: indeterminateFlag with: updateToolboxFlag
	"@message void MSG_COLOR_SELECTOR_UPDATE_FILLED_STATUS( SystemDrawMask drawMask = cl, Boolean indeterminateFlag = dx, word updateToolboxFlag = bp)"
	^self geosMessage: #[108 4 3 241 1 4 1 0] with: drawMask with: indeterminateFlag with: updateToolboxFlag!

selectorGetFilledMoniker: retValue
	"@message Boolean MSG_COLOR_SELECTOR_GET_FILLED_MONIKER( optr *retValue = dxcx)= cx"
	^self geosMessage: #[108 5 238 0 3 4] with: retValue!

selectorGetUnfilledMoniker: retValue
	"@message Boolean MSG_COLOR_SELECTOR_GET_UNFILLED_MONIKER( optr *retValue = dxcx)= cx"
	^self geosMessage: #[108 6 238 0 3 4] with: retValue!

selectorUpdateDrawMask: drawMask with: indeterminateFlag
	"@message void MSG_COLOR_SELECTOR_UPDATE_DRAW_MASK( SystemDrawMask drawMask = cl, Boolean indeterminateFlag = dx)"
	^self geosMessage: #[108 7 2 49 1 4 0] with: drawMask with: indeterminateFlag!

selectorGetDrawMask: retValue
	"@message Boolean MSG_COLOR_SELECTOR_GET_DRAW_MASK( SystemDrawMask *retValue = cl)= dx"
	^self geosMessage: #[108 8 106 1 3 4] with: retValue!

selectorSetDrawMask: drawMask with: indeterminateFlag
	"@message void MSG_COLOR_SELECTOR_SET_DRAW_MASK( SystemDrawMask drawMask = cl, Boolean indeterminateFlag = dx)"
	^self geosMessage: #[108 9 2 49 1 4 0] with: drawMask with: indeterminateFlag!

selectorApplyDrawMask: drawMask
	"@message void MSG_COLOR_SELECTOR_APPLY_DRAW_MASK( SystemDrawMask drawMask = cl)"
	^self geosMessage: #[108 10 2 1 1 0] with: drawMask!

selectorUpdatePattern: pattern with: indeterminateFlag
	"@message void MSG_COLOR_SELECTOR_UPDATE_PATTERN( GraphicPattern pattern = cx, Boolean indeterminateFlag = dx)"
	^self geosMessage: #[108 11 2 53 1 4 0] with: pattern with: indeterminateFlag!

selectorGetPattern: retValue
	"@message Boolean MSG_COLOR_SELECTOR_GET_PATTERN( GraphicPattern *retValue = cx)= dx"
	^self geosMessage: #[108 12 106 5 3 4] with: retValue!

selectorSetPattern: pattern with: indeterminateFlag
	"@message void MSG_COLOR_SELECTOR_SET_PATTERN( GraphicPattern pattern = cx, Boolean indeterminateFlag = dx)"
	^self geosMessage: #[108 13 2 53 1 4 0] with: pattern with: indeterminateFlag!

selectorApplyPattern: pattern
	"@message void MSG_COLOR_SELECTOR_APPLY_PATTERN( GraphicPattern pattern = cx)"
	^self geosMessage: #[108 14 2 5 1 0] with: pattern!

setFilledStatus
	"@message void MSG_CS_SET_FILLED_STATUS()"
	^self geosMessage: #[108 15 2 0 0]!

setCfIndex
	"@message void MSG_CS_SET_CF_INDEX()"
	^self geosMessage: #[108 16 2 0 0]!

setCfRgbRed
	"@message void MSG_CS_SET_CF_RGB_RED()"
	^self geosMessage: #[108 17 2 0 0]!

setCfRgbGreen
	"@message void MSG_CS_SET_CF_RGB_GREEN()"
	^self geosMessage: #[108 18 2 0 0]!

setCfRgbBlue
	"@message void MSG_CS_SET_CF_RGB_BLUE()"
	^self geosMessage: #[108 19 2 0 0]!

setDrawMask
	"@message void MSG_CS_SET_DRAW_MASK()"
	^self geosMessage: #[108 20 2 0 0]!

setPattern
	"@message void MSG_CS_SET_PATTERN()"
	^self geosMessage: #[108 21 2 0 0]!

!

